/*
 * Decompiled with CFR 0.152.
 */
package com.hoshino.cti.util;

import com.aetherteam.aether.data.resources.registries.AetherDimensions;
import com.google.common.collect.Lists;
import com.hoshino.cti.Modifier.Armor.AntiCurse;
import com.mojang.logging.LogUtils;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.WorldData;
import org.slf4j.Logger;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;

public class CommonUtil {
    private static final Logger LOGGER = LogUtils.getLogger();

    public static void Reload(MinecraftServer server) {
        LOGGER.info("Mod cti is now conducting a reload! It will take 114514 years.");
        PackRepository repository = server.m_129891_();
        WorldData data = server.m_129910_();
        Collection collection1 = repository.m_10523_();
        Collection<String> collection2 = CommonUtil.discoverNewPacks(repository, data, collection1);
        CommonUtil.reloadPacks(collection2, server);
    }

    public static void reloadPacks(Collection<String> p_138236_, MinecraftServer server) {
        server.m_129861_(p_138236_).exceptionally(p_138234_ -> {
            LOGGER.warn("Failed to execute reload", p_138234_);
            return null;
        });
    }

    public static Collection<String> discoverNewPacks(PackRepository repository, WorldData data, Collection<String> collection) {
        repository.m_10506_();
        ArrayList $$3 = Lists.newArrayList(collection);
        List $$4 = data.m_7513_().m_45855_();
        for (String $$5 : repository.m_10514_()) {
            if ($$4.contains($$5) || $$3.contains($$5)) continue;
            $$3.add($$5);
        }
        return $$3;
    }

    public static UUID UUIDFromSlot(EquipmentSlot slot, ModifierId modifierId) {
        return UUID.nameUUIDFromBytes((slot.m_20751_() + modifierId.toString()).getBytes(StandardCharsets.UTF_8));
    }

    public static boolean isAetherNight(Level level) {
        if (level.m_46472_() == AetherDimensions.AETHER_LEVEL) {
            return level.m_46468_() % 72000L > 39000L && level.m_46468_() % 72000L < 69000L;
        }
        return false;
    }

    public static int getArmorLevelingValue(TinkerDataCapability.TinkerDataKey<Integer> key, LivingEntity living) {
        AtomicInteger atomicInteger = new AtomicInteger(0);
        living.getCapability(TinkerDataCapability.CAPABILITY).ifPresent(cap -> atomicInteger.set((Integer)cap.get(key, (Object)0)));
        return atomicInteger.get();
    }

    public static boolean hasArmorLevel(TinkerDataCapability.TinkerDataKey<Integer> key, LivingEntity living) {
        return CommonUtil.getArmorLevelingValue(key, living) > 0;
    }

    public static int getAntiCurseLevel(LivingEntity living) {
        return CommonUtil.getArmorLevelingValue(AntiCurse.KEY_ANTI_CURSE, living);
    }
}

